#ifndef BASH_NOFORK_H
#define BASH_NOFORK_H

#define NOFORK_COPY_ON_CHANGE 0

#include <setjmp.h>

#include "command.h"
#include "general.h"
#include "hashlib.h"
#include "variables.h"
#include "stdc.h"

typedef struct oldenvbuf
{
  int fds[3];

  jmp_buf top_level;
  jmp_buf subshell_top_level;

  VAR_CONTEXT *global_variables;
  VAR_CONTEXT *shell_variables;
  HASH_TABLE *shell_functions;

  HASH_TABLE *temporary_env;
  char **non_unsettable_vars;

  char *dollar_vars[10];
  WORD_LIST *rest_of_args;

  char *pwd;
  char *oldpwd;
  char *curdir;

  int interactive;
  int interactive_shell;
  int login_shell;
  int subshell_environment;
  int subshell_exit_builtin;
  int exit_immediately_on_error;
  int variable_context;
  int dollar_dollar_pid;
  WORD_LIST *subst_assign_varlist;
  int echo_command_at_execute;

  SHELL_VAR *ifs_var;
  char *ifs_value;

  char *lastarg;

  struct oldenvbuf *prev_environment;

} OLDENVBUF;

typedef struct
{
  char *trap_val;
  int signal_mode;
} TRAPBUF;

extern int subshell_exit_value;
extern int subshell_exit_builtin;
extern int subshell_skip_commands;
extern int nofork_wait_status;
extern pid_t nofork_current_pid;

pid_t nofork_make_child_pid __P ((void));
void nofork_save_std_fds __P ((int fds[3]));
void nofork_restore_std_fds __P ((int fds[3]));
int nofork_save_all_environment __P ((OLDENVBUF *));
int nofork_restore_all_environment __P ((OLDENVBUF *));
void save_trap __P ((TRAPBUF *));
void restore_trap __P ((TRAPBUF *));
void copy_var_contexts_on_change(void);

int get_signal_modes __P ((int sig));
int set_signal_modes __P ((int sig, int modes));

int bash_spawnve __P ((char *path, char **args, char **envp));

#endif
