/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <errno.h>		/* For EINVAL */
#include <unistd.h>		/* For _PC_* */
#include <limits.h>		/* For *_MAX, etc. */

/* The _PC_* values for "name" should be defined in <unistd.h> */
/* The corresponding constants should be defined in <limits.h> */
long
pathconf(const char *path, int name)
{
    switch (name)
    {
    case _PC_LINK_MAX:		return LINK_MAX;
    case _PC_MAX_CANON:		return MAX_CANON;
    case _PC_MAX_INPUT:		return MAX_INPUT;
    case _PC_NAME_MAX:		return NAME_MAX;
    case _PC_PATH_MAX:		return PATH_MAX;
    case _PC_PIPE_BUF:		return PIPE_BUF;
#ifdef	_POSIX_CHOWN_RESTRICTED
    case _PC_CHOWN_RESTRICTED:	return _POSIX_CHOWN_RESTRICTED;
#else
    case _PC_CHOWN_RESTRICTED:	return -1;
#endif
#ifdef	_POSIX_NO_TRUNC
    case _PC_NO_TRUNC:		return _POSIX_NO_TRUNC;
#else
    case _PC_NO_TRUNC:		return -1;
#endif
#ifdef	_POSIX_VDISABLE
    case _PC_VDISABLE:		return _POSIX_VDISABLE;
#else
    case _PC_VDISABLE:		return -1;
#endif

    default:
	errno = EINVAL;
	return -1;
    }
}

long
fpathconf(int fildes, int name)
{
    return pathconf("/", name);
}
