/* This is file STUB.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <process.h>
#include <dos.h>
#include <io.h>
#include <string.h>

#include "gotypes.h"
#include "stubinfo.h"

StubInfo stub_info = {
  STUB_INFO_MAGIC,
  sizeof(StubInfo),
  "go32",
  {
    GO32_RELEASE_NUMBER,
    GO32_RELEASE_TYPE_C,
    GO32_MINOR_VERSION,
    GO32_MAJOR_VERSION
  },
  262144L,
  0,
  "",
  1,
  0L
};

unsigned _heaplen = 8192;
unsigned _stklen = 4096;

char hex[] = "0123456789abcdef";

void x2s(int v, char *s)
{
  int i;
  for (i=0; i<4; i++)
  {
    s[3-i] = hex[v&15];
    v >>= 4;
  }
  s[4] = 0;
}

char emsg[] = "Cannot exec ";
char emsg2[] = "\r\n";

main(int argc, char **argv)
{
  char newpsp[128+16];
  char s_argc[5], s_seg[5], s_argv[5];
  char s_info_seg[5], s_info_ofs[5];
  char s_psp[5];
  int r, oldpsp=_psp;

  x2s(argc, s_argc);
  x2s(_DS, s_seg);
  x2s((int)argv, s_argv);
  x2s(_DS, s_info_seg);
  x2s((int)(&stub_info), s_info_ofs);
  x2s(oldpsp, s_psp);

  /* fake out PSP or spawn will override arguments (uck) */
  _psp = FP_SEG(newpsp) + ((FP_OFF(newpsp)+15-128)>>4);
  /* must wait, as go32 reads argv/argc from our memory space */
  r = spawnlp(P_WAIT, stub_info.go32, stub_info.go32, "!proxy", s_argc, s_seg, s_argv, s_info_seg, s_info_ofs, s_psp, 0);
  _psp = oldpsp;

  if (r == -1)
  {
    write(2, emsg, sizeof(emsg)-1);
    write(2, stub_info.go32, strlen(stub_info.go32));
    write(2, emsg2, sizeof(emsg2)-1);
  }
  return r;
}
