#ifndef DOS_MALLOC_SUPPORT
#define DOS_MALLOC_SUPPORT

#include "config.h"

/* Functions for use by the shell to do malloc debugging and tracking. */
#if defined (USING_BASH_MALLOC)
# include "xmalloc.h"

# if !defined (DISABLE_MALLOC_WRAPPERS)
#  undef  malloc
#  define malloc(x)      sh_xmalloc((x), __FILE__, __LINE__)

#  undef  realloc
#  define realloc(x, n)  sh_xrealloc((x), (n), __FILE__, __LINE__)

#  undef  free
#  define free(x)        sh_xfree((x), __FILE__, __LINE__)
# endif /* !DISABLE_MALLOC_WRAPPERS */
#else  /* !USING_BASH_MALLOC */
/* Provide prototypes for xmalloc, xrealloc, xfree
   and  prototypes for malloc, realloc, free.  */

# include <stdlib.h>

void  xfree(void *_ptr);
void *xmalloc(size_t _size);
void *xrealloc(void *ptr, size_t _size);

#endif /* !USING_BASH_MALLOC */

#endif /* DOS_MALLOC_SUPPORT */
