#ifndef DOS_PIPE_SUPPORT
#define DOS_PIPE_SUPPORT

/* Always use DJGPP's implementations of these functions.
   In a sequence of headers, this header must be included as last! */


#define OLD_VERSION  0   /* no longer supported.  */

#if (OLD_VERSION - 0) == 0
#if (DOS_PIPE_DEBUG - 1) == 0
extern char *bash_script_command_line;
extern const char *bash_script_name;
extern int bash_script_line_number;
#endif /* DOS_PIPE_DEBUG */
#endif /* !OLD_VERSION */


void remove_pipe(int fd);

#undef  close
#define close rpl_close
int rpl_close(int fd);

#if (OLD_VERSION - 1) == 0
#undef  dup
#define dup rpl_dup
int rpl_dup(int old_handle);

#undef  dup2
#define dup2 rpl_dup2
int rpl_dup2(int existing_handle, int new_handle);
#endif /* OLD_VERSION */

#undef  pipe
#define pipe rpl_pipe
int rpl_pipe(int fds[2]);

#if (OLD_VERSION - 1) == 0
#undef  read
#define read rpl_read 
ssize_t rpl_read(int fd, void *buffer, size_t count);

#undef  _read
#define _read rpl__read 
ssize_t rpl__read(int fd, void *buffer, size_t count);

#undef  write
#define write rpl_write 
int rpl_write(int fd, const void *buffer, size_t count);
#endif /* OLD_VERSION */

#endif /* DOS_PIPE_SUPPORT */
