@echo off
echo Configuring pkg-config 0.23 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set HTML=enabled
if not "%HTML%" == "enabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set STATIC=enabled
if not "%STATIC%" == "enabled" goto SmallEnv
set GLIB=enabled
if not "%GLIB%" == "enabled" goto SmallEnv
set SYSINC=enabled
if not "%SYSINC%" == "enabled" goto SmallEnv
set SYSLIB=enabled
if not "%SYSLIB%" == "enabled" goto SmallEnv
set THREADS=disabled
if not "%THREADS%" == "disabled" goto SmallEnv
set DEBUG=disabled
if not "%DEBUG%" == "disabled" goto SmallEnv
set INDDEP=enabled
if not "%INDDEP%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv
set GLIB_VER=-1.2.10
if not "%GLIB_VER%" == "-1.2.10" goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto HTMLOption
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
:HTMLOption
if "%1" == "withhtml" goto NextArgument
if "%1" == "withHTML" goto NextArgument
if "%1" == "WITHHTML" goto NextArgument
if "%1" == "withouthtml" goto _WithoutHTML
if "%1" == "withoutHTML" goto _WithoutHTML
if "%1" == "WITHOUTHTML" goto _WithoutHTML
goto SilentOption
:_WithoutHTML
if "%1" == "withouthtml" set HTML=disabled
if "%1" == "withoutHTML" set HTML=disabled
if "%1" == "WITHOUTHTML" set HTML=disabled
if not "%HTML%" == "disabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto StaticOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:StaticOption
if "%1" == "static" goto NextArgument
if "%1" == "STATIC" goto NextArgument
if "%1" == "no-static" goto NoSTATIC
if "%1" == "no-STATIC" goto NoSTATIC
if "%1" == "NO-STATIC" goto NoSTATIC
goto GlibOption
:NoSTATIC
if "%1" == "no-static" set STATIC=disabled
if "%1" == "no-STATIC" set STATIC=disabled
if "%1" == "NO-STATIC" set STATIC=disabled
if not "%STATIC%" == "disabled" goto SmallEnv
goto NextArgument
:GlibOption
if "%1" == "glib" goto NextArgument
if "%1" == "GLIB" goto NextArgument
if "%1" == "no-glib" goto NoGLIB
if "%1" == "no-GLIB" goto NoGLIB
if "%1" == "NO-GLIB" goto NoGLIB
goto SysIncOption
:NoGLIB
if "%1" == "no-glib" set GLIB=disabled
if "%1" == "no-GLIB" set GLIB=disabled
if "%1" == "NO-GLIB" set GLIB=disabled
if not "%GLIB%" == "disabled" goto SmallEnv
goto NextArgument
:SysIncOption
if "%1" == "sysinc" goto NextArgument
if "%1" == "SYSINC" goto NextArgument
if "%1" == "no-sysinc" goto NoSYSINC
if "%1" == "no-SYSINC" goto NoSYSINC
if "%1" == "NO-SYSINC" goto NoSYSINC
goto SysLibOption
:NoSYSINC
if "%1" == "no-sysinc" set SYSINC=disabled
if "%1" == "no-SYSINC" set SYSINC=disabled
if "%1" == "NO-SYSINC" set SYSINC=disabled
if not "%SYSINC%" == "disabled" goto SmallEnv
goto NextArgument
:SysLibOption
if "%1" == "syslib" goto NextArgument
if "%1" == "SYSLIB" goto NextArgument
if "%1" == "no-syslib" goto NoSYSLIB
if "%1" == "no-SYSLIB" goto NoSYSLIB
if "%1" == "NO-SYSLIB" goto NoSYSLIB
goto ThreadsOption
:NoSYSLIB
if "%1" == "no-syslib" set SYSLIB=disabled
if "%1" == "no-SYSLIB" set SYSLIB=disabled
if "%1" == "NO-SYSLIB" set SYSLIB=disabled
if not "%SYSLIB%" == "disabled" goto SmallEnv
goto NextArgument
:ThreadsOption
if "%1" == "no-threads" goto NextArgument
if "%1" == "no-THREADS" goto NextArgument
if "%1" == "NO-THREADS" goto NextArgument
if "%1" == "threads" goto MultiThreading
if "%1" == "Threads" goto MultiThreading
if "%1" == "THREADS" goto MultiThreading
goto DebugOption
:MultiThreading
if "%1" == "threads" set THREADS=enabled
if "%1" == "Threads" set THREADS=enabled
if "%1" == "THREADS" set THREADS=enabled
if not "%THREADS%" == "enabled" goto SmallEnv
goto NextArgument
:DebugOption
if "%1" == "no-debug" goto NextArgument
if "%1" == "no-DEBUG" goto NextArgument
if "%1" == "NO-DEBUG" goto NextArgument
if "%1" == "debug" goto WithDebug
if "%1" == "Debug" goto WithDebug
if "%1" == "DEBUG" goto WithDebug
goto IndDepOption
:WithDebug
if "%1" == "debug" set DEBUG=enabled
if "%1" == "Debug" set DEBUG=enabled
if "%1" == "DEBUG" set DEBUG=enabled
if not "%DEBUG%" == "enabled" goto SmallEnv
goto NextArgument
:IndDepOption
if "%1" == "inddep" goto NextArgument
if "%1" == "INDDEP" goto NextArgument
if "%1" == "no-inddep" goto NoINDDEP
if "%1" == "no-INDDEP" goto NoINDDEP
if "%1" == "NO-INDDEP" goto NoINDDEP
goto SrcDirOption
:NoINDDEP
if "%1" == "no-inddep" set INDDEP=disabled
if "%1" == "no-INDDEP" set INDDEP=disabled
if "%1" == "NO-INDDEP" set INDDEP=disabled
if not "%INDDEP%" == "disabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
if not "--build" == "%1" if not "--host" == "%1" goto NextArgument
shift
set _ARGS=%ARGS%!#@EQ@#!%1
if not "%_ARGS%" == "%ARGS%!#@EQ@#!%1" goto SmallEnv
set ARGS=%_ARGS%
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"              echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"              echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"  echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled" echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"      echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"     echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"       echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"      echo --without-libintl-prefix >> args
if "%HTML%" == "enabled"                 echo --enable-html >> args
if "%HTML%" == "disabled"                echo --disable-html >> args
if "%SILENT%" == "enabled"               echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"              echo --disable-silent-rules >> args
if "%STATIC%" == "enabled"               echo --enable-static >> args
if "%STATIC%" == "disabled"              echo --disable-static >> args
if "%GLIB%" == "enabled"                 echo --with-internal-glib >> args
if "%GLIB%" == "disabled"                echo --without-internal-glib >> args
if "%SYSINC%" == "enabled"               echo --with-system-include-path=/dev/env/DJDIR/include >> args
if "%SYSINC%" == "disabled"              echo --without-system-include-path >> args
if "%SYSLIB%" == "enabled"               echo --with-system-library-path=/dev/env/DJDIR/lib >> args
if "%SYSLIB%" == "disabled"              echo --without-system-library-path >> args
if "%THREADS%" == "enabled"              echo --enable-threads >> args
if "%THREADS%" == "disabled"             echo --disable-threads >> args
if "%DEBUG%" == "enabled"                echo --enable-debug >> args
if "%DEBUG%" == "disabled"               echo --disable-debug >> args
if "%INDDEP%" == "enabled"               echo --enable-indirect-deps >> args
if "%INDDEP%" == "disabled"              echo --disable-indirect-deps >> args
if not "%ARGS%" == ""                    echo %ARGS% >> args

echo --prefix=/dev/env/DJDIR >> args
sed "/--build!#@EQ@#!/s/!#@EQ@#!/=/;/--host!#@EQ@#!/s/!#@EQ@#!/=/" args > args.txt
dtou args.txt
mv -f args.txt args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set HTML=
set SILENT=
set STATIC=
set GLIB=
set SYSINC=
set SYSLIB=
set THREADS=
set DEBUG=
set INDDEP=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure
md glib%GLIB_VER%
redir -e /dev/null update %XSRC%/glib%GLIB_VER%/configure.org ./glib%GLIB_VER%/configure
test -f ./glib%GLIB_VER%/configure
if errorlevel 1 update %XSRC%/glib%GLIB_VER%/configure ./glib%GLIB_VER%/configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./configure
dtou ./configure
touch -r configure.org ./configure
rm -f ./filename.ext
test -f ./glib%GLIB_VER%/configure.org
if errorlevel 1 update glib%GLIB_VER%/configure glib%GLIB_VER%/configure.org
sed -f %XSRC%/djgpp/config.sed glib%GLIB_VER%/configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./glib%GLIB_VER%/configure
dtou ./glib%GLIB_VER%/configure
touch -r glib%GLIB_VER%/configure.org ./glib%GLIB_VER%/configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/configh.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config_h.in %XSRC%/config.h-in
test -f %XSRC%/glib%GLIB_VER%/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/glib%GLIB_VER%/config.h.in %XSRC%/glib%GLIB_VER%/config.h-in
test -f %XSRC%/glib%GLIB_VER%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/glib%GLIB_VER%/config.h %XSRC%/glib%GLIB_VER%/config.h-in
test -f %XSRC%/glib%GLIB_VER%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/glib%GLIB_VER%/configh.in %XSRC%/glib%GLIB_VER%/config.h-in
test -f %XSRC%/glib%GLIB_VER%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/glib%GLIB_VER%/config_h.in %XSRC%/glib%GLIB_VER%/config.h-in
:@NOT_REQUIRED@test -f %XSRC%/po/Makefile.am.in
:@NOT_REQUIRED@if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
:@NOT_REQUIRED@test -f %XSRC%/po/Makefile.am-in
:@NOT_REQUIRED@if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
:@NOT_REQUIRED@test -f %XSRC%/po/Makefile.in.in
:@NOT_REQUIRED@if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
:@NOT_REQUIRED@test -f %XSRC%/po/Makefile.in-in
:@NOT_REQUIRED@if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in
:@NOT_REQUIRED@test -f %XSRC%/build-aux/snippet/c++defs.h
:@NOT_REQUIRED@if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/build-aux/snippet/c++defs.h %XSRC%/build-aux/snippet/cxxdefs.h
:@NOT_REQUIRED@test -f %XSRC%/lib/c++defs.h
:@NOT_REQUIRED@if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/c++defs.h %XSRC%/lib/cxxdefs.h
:@NOT_REQUIRED@test -f %XSRC%/tests/c++defs.h
:@NOT_REQUIRED@if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/tests/c++defs.h %XSRC%/tests/cxxdefs.h
:@NOT_REQUIRED@test -f %XSRC%/gnulib-tests/c++defs.h
:@NOT_REQUIRED@if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/gnulib-tests/c++defs.h %XSRC%/gnulib-tests/cxxdefs.h
:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/pkg-config.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/pkg-config..in %XSRC%/man/pkg-config.-in
:test -f %XSRC%/man/pkg-config.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/pkg-config. %XSRC%/man/pkg-config.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

Rem Update libtool files
echo Updating libtool scripts...
test -f %XSRC%/ltmain.org
if errorlevel 1 update %XSRC%/ltmain.sh %XSRC%/ltmain.org
sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/ltmain.org > ltmain.tmp
if errorlevel 1 goto Sed10Error
dtou ltmain.tmp
mv -f ltmain.tmp %XSRC%/ltmain.sh
test -f %XSRC%/glib%GLIB_VER%/ltmain.org
if errorlevel 1 update %XSRC%/glib%GLIB_VER%/ltmain.sh %XSRC%/glib%GLIB_VER%/ltmain.org
sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/glib%GLIB_VER%/ltmain.org > ltmain.tmp
if errorlevel 1 goto Sed10Error
dtou ltmain.tmp
mv -f ltmain.tmp %XSRC%/glib%GLIB_VER%/ltmain.sh

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/pkg-config.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls --without-included-gettext >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
cd glib%GLIB_VER%
sh ./configure ../@args
if errorlevel 1 goto 2RunConfigStatus
rm ../args
echo Done.
goto EditFiles
:2RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgFailed
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgFailed
cd ..
rm args
echo Done.
goto EditFiles
:CfgFailed
cd ..
goto CfgError

:EditFiles
echo Editing config.h...
update ./config.h ./config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./config_h.org > config.h
if errorlevel 1 goto Sed2Error
:InGLibDir
update ./glib%GLIB_VER%/config.h ./glib%GLIB_VER%/config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./glib%GLIB_VER%/config_h.org > config.glb
if errorlevel 1 goto Sed2Error
mv config.glb ./glib%GLIB_VER%/config.h
echo Done.

:NextEdit
echo Editing Makefile...
:test -f ./Makefile.org
:if errorlevel 1 update ./Makefile ./Makefile.org
update ./Makefile ./Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./Makefile.org > Makefile.src
if errorlevel 1 goto Sed3Error
mv Makefile.src ./Makefile
echo Done.

echo Editing check/Makefile...
update ./check/Makefile ./check/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./check/Makefile.org > Makefile.chk
if errorlevel 1 goto Sed4Error
mv Makefile.chk ./check/Makefile
echo Done.

echo Editing glib%GLIB_VER%/Makefile...
update ./glib%GLIB_VER%/Makefile ./glib%GLIB_VER%/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./glib%GLIB_VER%/Makefile.org > Makefile.glb
if errorlevel 1 goto Sed5Error
mv Makefile.glb ./glib%GLIB_VER%/Makefile
echo Done.

:@NOT_REQUIRED@echo Editing glib/glib/Makefile...
:@NOT_REQUIRED@update ./glib/glib/Makefile ./glib/glib/Makefile.org
:@NOT_REQUIRED@sed -f %XSRC%/djgpp/Makefile.sed ./glib/glib/Makefile.org > Makefile.glb
:@NOT_REQUIRED@if errorlevel 1 goto Sed6Error
:@NOT_REQUIRED@mv Makefile.glb ./glib/glib/Makefile
:@NOT_REQUIRED@echo Done.

:@NOT_REQUIRED@echo Editing glib/glib/gnulib/Makefile...
:@NOT_REQUIRED@update ./glib/glib/gnulib/Makefile ./glib/glib/gnulib/Makefile.org
:@NOT_REQUIRED@sed -f %XSRC%/djgpp/Makefile.sed ./glib/glib/gnulib/Makefile.org > Makefile.glb
:@NOT_REQUIRED@if errorlevel 1 goto Sed7Error
:@NOT_REQUIRED@mv Makefile.glb ./glib/glib/gnulib/Makefile
:@NOT_REQUIRED@echo Done.

:@NOT_REQUIRED@echo Editing glib/glib/libcharset/Makefile...
:@NOT_REQUIRED@update ./glib/glib/libcharset/Makefile ./glib/glib/libcharset/Makefile.org
:@NOT_REQUIRED@sed -f %XSRC%/djgpp/Makefile.sed ./glib/glib/libcharset/Makefile.org > Makefile.glb
:@NOT_REQUIRED@if errorlevel 1 goto Sed8Error
:@NOT_REQUIRED@mv Makefile.glb ./glib/glib/libcharset/Makefile
:@NOT_REQUIRED@echo Done.

:@NOT_REQUIRED@echo Editing glib/m4macros/Makefile...
:@NOT_REQUIRED@update ./glib/m4macros/Makefile ./glib/m4macros/Makefile.org
:@NOT_REQUIRED@sed -f %XSRC%/djgpp/Makefile.sed ./glib/m4macros/Makefile.org > Makefile.glb
:@NOT_REQUIRED@if errorlevel 1 goto Sed9Error
:@NOT_REQUIRED@mv Makefile.glb ./glib/m4macros/Makefile
:@NOT_REQUIRED@echo Done.

echo Editing glib%GLIB_VER%/tests/Makefile...
update ./glib%GLIB_VER%/tests/Makefile ./glib%GLIB_VER%/tests/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./glib%GLIB_VER%/tests/Makefile.org > Makefile.glb
if errorlevel 1 goto Sed9Error
mv Makefile.glb ./glib%GLIB_VER%/tests/Makefile
echo Done.

Rem Create po/LINGUAS file or the build fails.
update %XSRC%/po/LINGUAS ./po/LINGUAS
goto End

:Sed1Error
echo ./configure script editing failed!
goto End

:Sed2Error
echo config.h fixing failed!
goto End

:Sed3Error
echo Makefile fixing failed!
goto End

:Sed4Error
echo check/Makefile fixing failed!
goto End

:Sed5Error
echo glib/Makefile fixing failed!
goto End

:Sed6Error
echo glib/glib/Makefile fixing failed!
goto End

:Sed7Error
echo glib/glib/gnulib/Makefile fixing failed!
goto End

:Sed8Error
echo glib/glib/libcharset/Makefile fixing failed!
goto End

:Sed9Error
echo glib/m4macros/Makefile fixing failed!
goto End

:Sed10Error
echo ./ltmain.sh editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set SILENT=
set STATIC=
set GLIB=
set SYSINC=
set SYSLIB=
set THREADS=
set DEBUG=
set INDDEP=
set XSRC=
set GLIB_VER=
