/*!\file portability.h
 *
 * Defines macros to hide the call of OS specific functions instead of posix functions.
 *
 *  Must always be included as last!!!
 */

#ifndef _w32_PORTABILITY_H
#define _w32_PORTABILITY_H


/*
 *  For DJGPP allow to use _chmod instead of access.
 */
#ifdef __DJGPP__
# undef  access
# define access(filename, flags)  (_chmod((filename), (flags)) == -1 ? -1 : 0)
#endif

#endif /* _w32_CONFIG_H */
