#! /bin/sh
#
#  mktree.sh
#
#  Shell script to create the directory tree for the binary and
#  source zip files that do conform to DJGPP installation tree
#  from the original watt32b.zip and watt32s.zip.
#  All components from the original archives that are not
#  relevant for the DJGPP port are removed!
#  The original archives can be retrieved from http://www.watt-32.net/
#  as:
#     http://www.watt-32.net/watt32s-Jan-2016.zip
#     http://www.watt-32.net/watt32b.zip
#


original_bin_archive=watt32b.zip
original_src_archive=watt32s.zip
src_archive=watt.tar


cat > script.sh << EOS
#! /bin/sh
original_bin=wb
original_src=ws
port_bin=bins
port_src=srcs

# 0) Loeschen alter Verzeichnisse.
rm -vfr \${port_bin} \${port_src} \${original_bin} \${original_src}


# 1) Extrahieren von watt32b.zip und watt32s.zip in zwei verschieden Verzeichnisse.
mkdir \${original_bin}
cd \${original_bin}
unzip ../${original_bin_archive}
cd ..
mkdir \${original_src}
cd \${original_src}
unzip ../${original_src_archive}
cd ..


# 2) Inhalt des Verzeichnisses von watt32s.zip in das neue Verzeichnis kopieren:

mkdir -p \${port_src}/contrib/watt/djgpp
mkdir -p \${port_src}/manifest
mv -vf \${original_src}/* \${port_src}/contrib/watt


# 3) Loeschen der Verzeichnisse:
#      srcs/contrib/watt/inc/w32-fakes
#      srcs/contrib/watt/lib
#      srcs/contrib/watt/src/digmars
#      srcs/contrib/watt/src/ladsoft
#      srcs/contrib/watt/src/Python
#      srcs/contrib/watt/src/quickc
#      srcs/contrib/watt/src/turboc
#      srcs/contrib/watt/src/VisualStudio
#      srcs/contrib/watt/util/linux
#      srcs/contrib/watt/util/win32

rm -vfr \${port_src}/contrib/watt/inc/w32-fakes
rm -vfr \${port_src}/contrib/watt/lib
rm -vfr \${port_src}/contrib/watt/src/digmars
rm -vfr \${port_src}/contrib/watt/src/ladsoft
rm -vfr \${port_src}/contrib/watt/src/Python
rm -vfr \${port_src}/contrib/watt/src/quickc
rm -vfr \${port_src}/contrib/watt/src/turboc
rm -vfr \${port_src}/contrib/watt/src/VisualStudio
rm -vfr \${port_src}/contrib/watt/util/linux


# 4) Loeschen aller nicht benoetigten Dateien aus dem /src Verzeichnis.

rm -vf \${port_src}/contrib/watt/src/all_vc.bat \\
       \${port_src}/contrib/watt/src/all_win.bat \\
       \${port_src}/contrib/watt/src/pkt_stub.h \\
       \${port_src}/contrib/watt/src/watt-32.rc


# 5) Loeschen aller nicht benoetigten Dateien aus dem /src/tests Verzeichnis.

rm -vf \${port_src}/contrib/watt/src/tests/makefile.bc \\
       \${port_src}/contrib/watt/src/tests/makefile.cyg \\
       \${port_src}/contrib/watt/src/tests/makefile.dmc \\
       \${port_src}/contrib/watt/src/tests/makefile.hc \\
       \${port_src}/contrib/watt/src/tests/makefile.msvc32 \\
       \${port_src}/contrib/watt/src/tests/makefile.msvc64 \\
       \${port_src}/contrib/watt/src/tests/makefile.mw \\
       \${port_src}/contrib/watt/src/tests/makefile.wc


# 6) Loeschen aller nicht benoetigten Programme aus dem /util Verzeichnis.

rm -vf \${port_src}/contrib/watt/util/bcc_err.exe \\
       \${port_src}/contrib/watt/util/wc_err.exe \\
       \${port_src}/contrib/watt/util/ms_err.exe \\
       \${port_src}/contrib/watt/util/vc_err.exe \\
       \${port_src}/contrib/watt/util/hc_err.exe \\
       \${port_src}/contrib/watt/util/tcc_err.exe \\
       \${port_src}/contrib/watt/util/dj_err.exe \\
       \${port_src}/contrib/watt/util/dm_err.exe \\
       \${port_src}/contrib/watt/util/mw_err.exe \\
       \${port_src}/contrib/watt/util/ls_err.exe \\
       \${port_src}/contrib/watt/util/lcc_err.exe \\
       \${port_src}/contrib/watt/util/po_err.exe \\
       \${port_src}/contrib/watt/util/nasm32.exe \\
       \${port_src}/contrib/watt/util/clang_err.exe \\
       \${port_src}/contrib/watt/util/dxegen.exe \\
       \${port_src}/contrib/watt/util/mkimp.exe \\
       \${port_src}/contrib/watt/util/mklang.exe \\
       \${port_src}/contrib/watt/util/mw64_err.exe


# 7) Loeschen aller nicht benoetigten Programme aus dem /util/win32 Verzeichnis.

 rm -vf \${port_src}/contrib/watt/util/win32/bcc_err.exe \\
        \${port_src}/contrib/watt/util/win32/clang_err.exe \\
        \${port_src}/contrib/watt/util/win32/mklang.exe \\
        \${port_src}/contrib/watt/util/win32/mkmake2.exe \\
        \${port_src}/contrib/watt/util/win32/wc_err.exe


# 8) Kopieren der benoetigten C-Dateien und Makefiles aus dem /bin Verzeichnis von watt32b.zip
#    in das /bin Verzeichnis von srcs/contrib/watt.

cp -vf \${original_bin}/bin/djcommon.mak \${port_src}/contrib/watt/bin/djcommon.mak
cp -vf \${original_bin}/bin/djgpp.mak \${port_src}/contrib/watt/bin/djgpp.mak
cp -vf \${original_bin}/bin/ping.c \${port_src}/contrib/watt/bin/ping.c
cp -vf \${original_bin}/bin/tcpinfo.c \${port_src}/contrib/watt/bin/tcpinfo.c
cp -vf \${original_bin}/bin/tiny.c \${port_src}/contrib/watt/bin/tiny.c


# 9) Kopieren der Dateien in das /bins Verzeichnis.

mkdir -p \${port_bin}/contrib/watt/djgpp
mkdir -p \${port_bin}/net/watt/bin
mkdir -p \${port_bin}/net/watt/inc
mkdir -p \${port_bin}/net/watt/lib
mkdir -p \${port_bin}/manifest
cp -vf \${port_src}/contrib/watt/bin/*cfg \${port_bin}/net/watt/bin
cp -vf \${port_src}/contrib/watt/bin/rpc \${port_bin}/net/watt/bin


# 10) Loeschen aller nicht benoetigten .err Dateien.

rm -vf \${port_bin}/net/watt/inc/sys/borlandc.err \\
       \${port_bin}/net/watt/inc/sys/clang.err \\
       \${port_bin}/net/watt/inc/sys/digmars.err \\
       \${port_bin}/net/watt/inc/sys/djgpp.err \\
       \${port_bin}/net/watt/inc/sys/highc.err \\
       \${port_bin}/net/watt/inc/sys/ladsoft.err \\
       \${port_bin}/net/watt/inc/sys/lcc.err \\
       \${port_bin}/net/watt/inc/sys/mingw32.err \\
       \${port_bin}/net/watt/inc/sys/mingw64.err \\
       \${port_bin}/net/watt/inc/sys/pellesc.err \\
       \${port_bin}/net/watt/inc/sys/quickc.err \\
       \${port_bin}/net/watt/inc/sys/turboc.err \\
       \${port_bin}/net/watt/inc/sys/visualc.err \\
       \${port_bin}/net/watt/inc/sys/watcom.err

rm -vf \${port_src}/contrib/watt/inc/sys/borlandc.err \\
       \${port_src}/contrib/watt/inc/sys/clang.err \\
       \${port_src}/contrib/watt/inc/sys/digmars.err \\
       \${port_src}/contrib/watt/inc/sys/djgpp.err \\
       \${port_src}/contrib/watt/inc/sys/highc.err \\
       \${port_src}/contrib/watt/inc/sys/ladsoft.err \\
       \${port_src}/contrib/watt/inc/sys/lcc.err \\
       \${port_src}/contrib/watt/inc/sys/mingw32.err \\
       \${port_src}/contrib/watt/inc/sys/mingw64.err \\
       \${port_src}/contrib/watt/inc/sys/pellesc.err \\
       \${port_src}/contrib/watt/inc/sys/quickc.err \\
       \${port_src}/contrib/watt/inc/sys/turboc.err \\
       \${port_src}/contrib/watt/inc/sys/visualc.err \\
       \${port_src}/contrib/watt/inc/sys/watcom.err


# 11) Erzeugen der benoetigten Verzeichnisse in Loeschen der temporaeren Verzeichnisse.

mkdir -p \${port_src}/contrib/watt/lib


# 12) Erzeugen des Arbeitsarchives.

rm -vf ${src_archive} ${src_archive}.bz2
cd \${port_src}/contrib
tar -cvf ../../${src_archive} *
cd ../../
bzip2 -9v ${src_archive}


# 13) Loeschen der temporaeren Verzeichnisse.

rm -vfr \${port_bin} \${port_src} \${original_bin} \${original_src}


EOS

./script.sh
rm -f ./script.sh
