@echo off
::
:: Note: the command line options are case sensitive
:: under the brain-dead CMD shell.
:: (use lower case args or switch to JPsoft's freeware TCC/LE).
::
if %WATT_ROOT%. ==. goto not_set
if not exist %WATT_ROOT%\src\makefile.all goto not_set

::
:: These can be run under plain DOS or Win-XP.
:: But all of them are built using djgpp. Hence they fail
:: to run under e.g. vDOS on Windows 10.
::
set  MKMAKE=..\util\mkmake.exe
set   MKDEP=..\util\mkdep.exe
set  WC_ERR=..\util\wc_err.exe
set BCC_ERR=..\util\bcc_err.exe
set   BIN2C=..\util\bin2c.exe
set  BIN2C_=../util/bin2c.exe
set    NASM=..\util\nasm.exe
set   NASM_=../util/nasm.exe

if %OS%. ==.     goto is_dos
:: if %1. == djgpp. goto is_dos

::
:: Use these programs for Windows
::
set  MKMAKE=..\util\win32\mkmake.exe
set   MKDEP=..\util\win32\mkdep.exe
set  WC_ERR=..\util\win32\wc_err.exe
set BCC_ERR=..\util\win32\bcc_err.exe
set   BIN2C=..\util\win32\bin2c.exe
set  BIN2C_=../util/win32/bin2c.exe
set    NASM=..\util\win32\nasm.exe
set   NASM_=../util/win32/nasm.exe

:is_dos

:start
if %1.==clang.    goto clang
if %1.==mingw32.  goto mingw32
if %1.==mingw64.  goto mingw64
if %1.==borland.  goto borland
if %1.==cygwin.   goto cygwin
if %1.==cygwin64. goto cygwin64
if %1.==djgpp.    goto djgpp
if %1.==digmars.  goto digmars
if %1.==ladsoft.  goto ladsoft
if %1.==lcc.      goto lcc
if %1.==pellesc.  goto pellesc
if %1.==highc.    goto highc
if %1.==visualc.  goto visualc
if %1.==watcom.   goto watcom
if %1.==all.      goto all
if %1.==clean.    goto clean
if %1.==-h.       goto usage
if %1.==-?.       goto usage
if not %1.==.     goto bad_usage
goto quit

::--------------------------------------------------------------------------
:borland
::
echo Generating Borland-C makefiles, directories, errnos and dependencies
%MKMAKE% -o bcc_s.mak -d borland\small makefile.all BORLAND SMALL
%MKMAKE% -o bcc_l.mak -d borland\large makefile.all BORLAND LARGE
%MKMAKE% -o bcc_f.mak -d borland\flat  makefile.all BORLAND FLAT
%MKMAKE% -o bcc_w.mak -d borland\win32 makefile.all BORLAND WIN32
%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h > borland\watt32.dep

echo neterr.c:  borland\syserr.c       >> borland\watt32.dep

%BCC_ERR% -s > borland\syserr.c
%BCC_ERR% -e > ..\inc\sys\borlandc.err

echo Run make to make target(s):
echo   E.g. "maker -f bcc_l.mak" for large model
goto next

::--------------------------------------------------------------------------
:watcom
::
echo Generating Watcom makefiles, directories, errnos and dependencies
%MKMAKE% -o watcom_s.mak -d watcom\small makefile.all WATCOM SMALL
%MKMAKE% -o watcom_l.mak -d watcom\large makefile.all WATCOM LARGE
%MKMAKE% -o watcom_f.mak -d watcom\flat  makefile.all WATCOM FLAT
%MKMAKE% -o watcom_x.mak -d watcom\x32vm makefile.all WATCOM FLAT X32VM
%MKMAKE% -o watcom_w.mak -d watcom\win32 makefile.all WATCOM WIN32

%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h > watcom\watt32.dep

echo neterr.c: watcom\syserr.c >> watcom\watt32.dep

%WC_ERR% -s > watcom\syserr.c
%WC_ERR% -e > ..\inc\sys\watcom.err

echo Run wmake to make target(s):
echo   E.g. "wmake -f watcom_l.mak" for large model
goto next

::--------------------------------------------------------------------------
:highc
::
:: Need to use GNU-make (on Windows) to build for High-C.
::
echo Generating Metaware High-C makefile, directory, errnos and dependencies
%MKMAKE% -o highc.mak -d highc makefile.all HIGHC FLAT
%MKDEP% -s.obj -p$(OBJDIR)/ *.c *.h > highc\watt32.dep

echo neterr.c: highc/syserr.c >> highc\watt32.dep

..\util\hc_err -s > highc\syserr.c
..\util\hc_err -e > ..\inc\sys\highc.err

echo Run GNU make to make target:
echo   "make -f highc.mak"
goto next

::--------------------------------------------------------------------------
:ladsoft
::
echo Generating LADsoft makefile, directory, errnos and dependencies
%MKMAKE% -o ladsoft.mak -d ladsoft makefile.all LADSOFT
%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h > ladsoft\watt32.dep

echo neterr.c: ladsoft\syserr.c >> ladsoft\watt32.dep

..\util\ls_err -s > ladsoft\syserr.c
..\util\ls_err -e > ..\inc\sys\ladsoft.err

echo Run a Borland compatible make to make target:
echo   "maker -f ladsoft.mak"
goto next

::--------------------------------------------------------------------------
:digmars
::
echo Generating Digital Mars makefiles, directories, errnos and dependencies
%MKMAKE% -o dmars_s.mak -d digmars\small makefile.all DIGMARS SMALL
%MKMAKE% -o dmars_l.mak -d digmars\large makefile.all DIGMARS LARGE
%MKMAKE% -o dmars_x.mak -d digmars\x32vm makefile.all DIGMARS FLAT X32VM
%MKMAKE% -o dmars_p.mak -d digmars\phar  makefile.all DIGMARS FLAT PHARLAP
%MKMAKE% -o dmars_w.mak -d digmars\win32 makefile.all DIGMARS WIN32
%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h > digmars\watt32.dep

echo neterr.c : digmars\syserr.c >> digmars\watt32.dep

..\util\dm_err -s > digmars\syserr.c
..\util\dm_err -e > ..\inc\sys\digmars.err

echo Run make to make target(s):
echo   E.g. "maker -f dmars_l.mak" for large model
goto next

::--------------------------------------------------------------------------
:djgpp
::
echo Generating DJGPP makefile, directory, errnos and dependencies
%MKMAKE% -o djgpp.mak -d djgpp makefile.all DJGPP FLAT
%MKDEP% -s.o -p$(OBJDIR)/ *.c *.h > djgpp\watt32.dep

echo neterr.c: djgpp/syserr.c >> djgpp\watt32.dep

..\util\dj_err -s > djgpp\syserr.c
..\util\dj_err -e > ..\inc\sys\djgpp.err

echo Run GNU make to make target:
echo   make -f djgpp.mak
goto next

::--------------------------------------------------------------------------
:visualc
::
echo off
echo Generating Microsoft Visual-C (x86/x64) makefiles, directories, errnos and dependencies
%MKMAKE% -o visualc-release.mak    -d visualc\32bit\release makefile.all VISUALC WIN32 RELEASE
%MKMAKE% -o visualc-release_64.mak -d visualc\64bit\release makefile.all VISUALC WIN64 RELEASE
%MKMAKE% -o visualc-debug.mak      -d visualc\32bit\debug   makefile.all VISUALC WIN32 DEBUG
%MKMAKE% -o visualc-debug_64.mak   -d visualc\64bit\debug   makefile.all VISUALC WIN64 DEBUG
%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h                                > visualc\watt32.dep

echo $(OBJDIR)\stkwalk.obj: stkwalk.cpp wattcp.h misc.h stkwalk.h >> visualc\watt32.dep
echo neterr.c:  visualc\syserr.c                                  >> visualc\watt32.dep

..\util\vc_err -s > visualc\syserr.c
..\util\vc_err -e > ..\inc\sys\visualc.err

::
:: If %CL% does not contain a '-D_WIN32_WINNT' already, add a '-D_WIN32_WINNT=0x0601' to %CL%.
::
echo %CL% | %SystemRoot%\system32\find.exe "-D_WIN32_WINNT" > NUL
if errorlevel 1 (
  echo Setting "_WIN32_WINNT=0x0601". Change to suite your OS or SDK.
  set CL=%CL% -D_WIN32_WINNT=0x0601
)

echo Run nmake to make target(s):
echo   E.g. "nmake -f visualc-release.mak"
goto next

::--------------------------------------------------------------------------
:mingw32
::
echo Generating MinGW32 makefile, directory, errnos and dependencies
%MKMAKE% -o MinGW32.mak -d MinGW32 makefile.all MINGW32 WIN32
%MKDEP% -s.o -p$(OBJDIR)/ *.c *.h > MinGW32\watt32.dep

echo neterr.c: MinGW32/syserr.c >> MinGW32\watt32.dep

..\util\mw_err -s > MinGW32\syserr.c
..\util\mw_err -e > ..\inc\sys\mingw32.err

echo Run GNU make to make target:
echo   make -f MinGW32.mak
make.exe -s -f ../util/pkg-conf.mak mingw32_pkg
goto next

::--------------------------------------------------------------------------
:mingw64
::
echo Generating MinGW64-w64 makefile, directory, errnos and dependencies
%MKMAKE% -o MinGW64_32.mak             -d MinGW64\32bit makefile.all MINGW64 WIN32
%MKMAKE% -o MinGW64_64.mak             -d MinGW64\64bit makefile.all MINGW64 WIN64
%MKDEP% -s.o -p$(OBJDIR)/32bit/ *.c *.h > MinGW64\32bit\watt32.dep
%MKDEP% -s.o -p$(OBJDIR)/64bit/ *.c *.h > MinGW64\64bit\watt32.dep

echo neterr.c: MinGW64/syserr.c >> MinGW64\32bit\watt32.dep
echo neterr.c: MinGW64/syserr.c >> MinGW64\64bit\watt32.dep

..\util\mw64_err -s > MinGW64\syserr.c
..\util\mw64_err -e > ..\inc\sys\mingw64.err

echo Run GNU make to make target:
echo   make -f MinGW64_32.mak
echo or
echo   make -f MinGW64_64.mak
make.exe -s -f ../util/pkg-conf.mak mingw64_pkg
goto next

::--------------------------------------------------------------------------
:cygwin
::
echo Generating CygWin makefile, directory and dependencies
%MKMAKE% -o CygWin.mak -d CygWin\32bit makefile.all CYGWIN WIN32
%MKDEP% -s.o -p$(OBJDIR)/ *.c *.h > CygWin\32bit\watt32.dep

echo Run GNU make to make target:
echo   make -f CygWin.mak
make.exe -s -f ../util/pkg-conf.mak cygwin_pkg
goto next

::--------------------------------------------------------------------------
:cygwin64
::
echo Generating CygWin64 makefile, directory and dependencies
%MKMAKE% -o CygWin_64.mak -d CygWin\64bit makefile.all CYGWIN64 WIN64
%MKDEP% -s.o -p$(OBJDIR)/ *.c *.h > CygWin\64bit\watt32.dep

echo Run GNU make to make target:
echo   make -f CygWin_64.mak
make.exe -s -f ../util/pkg-conf.mak cygwin64_pkg
goto next

::--------------------------------------------------------------------------
:pellesc
::
echo Generating PellesC makefile, directory, errnos and dependencies
%MKMAKE% -o pellesc.mak    -d pellesc\32bit makefile.all PELLESC WIN32
%MKMAKE% -o pellesc_64.mak -d pellesc\64bit makefile.all PELLESC WIN64

%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h > pellesc\watt32.dep

echo neterr.c: pellesc\syserr.c >> pellesc\watt32.dep

..\util\po_err -s > pellesc\syserr.c
..\util\po_err -e > ..\inc\sys\pellesc.err

echo Run pomake to make targets:
echo   E.g. "pomake -f pellesc.mak"
echo   E.g. "pomake -f pellesc_64.mak"
goto next


::--------------------------------------------------------------------------
:lcc
::
echo Generating LCC-Win32 makefile, directory, errnos and dependencies
%MKMAKE% -o lcc.mak -d lcc makefile.all LCC WIN32
%MKDEP% -s.obj -p$(OBJDIR)\ *.c *.h > lcc\watt32.dep

echo neterr.c: lcc\syserr.c >> lcc\watt32.dep

..\util\lcc_err -s > lcc\syserr.c
..\util\lcc_err -e > ..\inc\sys\lcc.err

echo Run make to make target:
echo   E.g. "maker -f lcc.mak"
goto next

::--------------------------------------------------------------------------
:clang
::
echo Generating CLang-Win32 makefile, directory, errnos and dependencies
%MKMAKE% -o clang.mak -d clang makefile.all CLANG WIN32
%MKDEP% -s.obj -p$(OBJDIR)/ *.c *.h > clang\watt32.dep

echo neterr.c: clang\syserr.c >> clang\watt32.dep

..\util\win32\clang_err -s > clang\syserr.c
..\util\win32\clang_err -e > ..\inc\sys\clang.err

echo Run GNU make to make target:
echo   E.g. "make -f clang.mak"
goto next

::--------------------------------------------------------------------------

:bad_usage
echo Unknown option '%1'.

::--------------------------------------------------------------------------
:usage
::
echo Configuring Watt-32 tcp/ip targets.
echo Usage: %0 {borland, watcom, highc, ladsoft, pellesc,
echo           djgpp, digmars, mingw32, mingw64, cygwin, visualc, clang, all, clean}
goto quit

::--------------------------------------------------------------------------
:clean
::
del djgpp.mak
del watcom_*.mak
del bcc_*.mak
del tcc_*.mak
del highc.mak
del dmars_*.mak
del ladsoft.mak
del visualc-release.mak
del visualc-debug.mak
del visualc-release_64.mak
del visualc-debug_64.mak
del MinGW32.mak
del MinGW64_32.mak
del MinGW64_64.mak
del CygWin.mak
del CygWin_64.mak
del watcom_w.mak
del pellesc.mak
del pellesc_64.mak
del highc.mak
del lcc.mak
del clang.mak

del djgpp\watt32.dep
del borland\watt32.dep
del highc\watt32.dep
del digmars\watt32.dep
del ladsoft\watt32.dep
del visualc\watt32.dep
del MinGW32\watt32.dep
del MinGW64\watt32.dep
del CygWin\watt32.dep
del CygWin\64bit\watt32.dep
del watcom\watt32.dep
del pellesc\watt32.dep
del highc\watt32.dep
del lcc\watt32.dep
del clang\watt32.dep

del djgpp\syserr.c
del watcom\syserr.c
del borland\syserr.c
del highc\syserr.c
del digmars\syserr.c
del ladsoft\syserr.c
del visualc\syserr.c
del MinGW32\syserr.c
del MinGW64\syserr.c
del pellesc\syserr.c
del highc\syserr.c
del lcc\syserr.c
del clang\syserr.c

del ..\inc\sys\djgpp.err
del ..\inc\sys\watcom.err
del ..\inc\sys\borlandc.err
del ..\inc\sys\highc.err
del ..\inc\sys\digmars.err
del ..\inc\sys\ladsoft.err
del ..\inc\sys\visualc.err
del ..\inc\sys\mingw32.err
del ..\inc\sys\mingw64.err
del ..\inc\sys\pellesc.err
del ..\inc\sys\highc.err
del ..\inc\sys\lcc.err
del ..\inc\sys\clang.err
goto next

::------------------------------------------------------------
:all
::
call %0 borland  %2
call %0 watcom   %2
call %0 djgpp    %2
call %0 digmars  %2
call %0 ladsoft  %2
call %0 visualc  %2
call %0 mingw32  %2
call %0 mingw64  %2
call %0 cygwin   %2
call %0 cygwin64 %2
call %0 watcom   %2
call %0 lcc      %2
call %0 clang    %2
call %0 pellesc  %2
call %0 highc    %2
:next
shift
echo.

if %1.==. goto quit
goto start

:not_set
echo Environment variable WATT_ROOT not set (or incorrectly set).
echo Put this in your AUTOEXEC.BAT or environment:
echo   e.g. "SET WATT_ROOT=C:\NET\WATT"

:quit

