#
# !! NOT YET WORKING  !!
#
# Makefile for Watt-32 TCP/IP stack.
#
# Just a test makefile to use MingW-gcc to compile the
# djgpp version of Watt-32. It will not run. Just to
# check the gcc warnings.
#

DJDIR ?= e:/djgpp

ASM_SOURCE = asmpkt.asm chksum0.asm cpumodel.asm

CORE_SOURCE = bsdname.c  btree.c    chksum.c   country.c  crc.c      dynip.c    \
              echo.c     fortify.c  getopt.c   gettod.c   highc.c    idna.c     \
              ip4_frag.c ip4_in.c   ip4_out.c  ip6_in.c   ip6_out.c  language.c \
              lookup.c   loopback.c misc.c     netback.c  oldstuff.c packet32.c \
              pc_cbrk.c  pcarp.c    pcbootp.c  pcbuf.c    pcconfig.c pcdbug.c   \
              pcdhcp.c   pcdns.c    pcicmp.c   pcicmp6.c  pcigmp.c   pcintr.c   \
              pcping.c   pcpkt.c    pcpkt32.c  pcqueue.c  pcrarp.c   pcrecv.c   \
              pcsed.c    pcstat.c   pctcp.c    ports.c    powerpak.c ppp.c      \
              pppoe.c    profile.c  punycode.c qmsg.c     rs232.c    run.c      \
              settod.c   sock_dbu.c sock_in.c  sock_ini.c sock_io.c  sock_prn.c \
              sock_scn.c sock_sel.c split.c    strings.c  swsvpkt.c  tcp_fsm.c  \
              tcp_md5.c  tftp.c     timer.c    udp_rev.c  version.c  wdpmi.c    \
              win_dll.c  winadinf.c winmisc.c  winpkt.c   x32vm.c

BSD_SOURCE =  accept.c   bind.c     bsddbug.c  close.c    connect.c  fcntl.c    \
              fsext.c    get_ai.c   get_ip.c   get_ni.c   get_xbyr.c geteth.c   \
              gethost.c  gethost6.c getname.c  getnet.c   getprot.c  getput.c   \
              getserv.c  ioctl.c    linkaddr.c listen.c   netaddr.c  neterr.c   \
              nettime.c  nsapaddr.c poll.c     presaddr.c printk.c   receive.c  \
              select.c   shutdown.c signal.c   socket.c   sockopt.c  stream.c   \
              syslog.c   syslog2.c  transmit.c

BIND_SOURCE = res_comp.c res_data.c res_debu.c res_init.c res_loc.c res_mkqu.c \
              res_quer.c res_send.c

ZLIB_SOURCE = zadler32.c  zcompres.c zcrc32.c   zgzio.c \
              zuncompr.c  zdeflate.c ztrees.c   zutil.c \
              zinflate.c  zinfback.c zinftree.c zinffast.c

C_SOURCE = $(CORE_SOURCE) $(BSD_SOURCE) $(BIND_SOURCE) $(ZLIB_SOURCE)

OBJS = \
       $(OBJDIR)\chksum0.obj  $(OBJDIR)\cpumodel.obj  \
       $(OBJDIR)\accept.obj   $(OBJDIR)\bind.obj      \
       $(OBJDIR)\bsddbug.obj  $(OBJDIR)\bsdname.obj   \
       $(OBJDIR)\btree.obj    $(OBJDIR)\chksum.obj    \
       $(OBJDIR)\close.obj    $(OBJDIR)\connect.obj   \
       $(OBJDIR)\country.obj  $(OBJDIR)\crc.obj       \
       $(OBJDIR)\dynip.obj    $(OBJDIR)\echo.obj      \
       $(OBJDIR)\fcntl.obj    $(OBJDIR)\fortify.obj   \
       $(OBJDIR)\fsext.obj    $(OBJDIR)\get_ai.obj    \
       $(OBJDIR)\get_ip.obj   $(OBJDIR)\get_ni.obj    \
       $(OBJDIR)\get_xbyr.obj $(OBJDIR)\geteth.obj    \
       $(OBJDIR)\gethost.obj  $(OBJDIR)\gethost6.obj  \
       $(OBJDIR)\getname.obj  $(OBJDIR)\getnet.obj    \
       $(OBJDIR)\getopt.obj   $(OBJDIR)\getprot.obj   \
       $(OBJDIR)\getput.obj   $(OBJDIR)\getserv.obj   \
       $(OBJDIR)\gettod.obj   $(OBJDIR)\idna.obj      \
       $(OBJDIR)\ioctl.obj    $(OBJDIR)\ip4_frag.obj  \
       $(OBJDIR)\ip4_in.obj   $(OBJDIR)\ip4_out.obj   \
       $(OBJDIR)\ip6_in.obj   $(OBJDIR)\ip6_out.obj   \
       $(OBJDIR)\language.obj $(OBJDIR)\linkaddr.obj  \
       $(OBJDIR)\listen.obj   $(OBJDIR)\lookup.obj    \
       $(OBJDIR)\loopback.obj $(OBJDIR)\misc.obj      \
       $(OBJDIR)\netaddr.obj  $(OBJDIR)\netback.obj   \
       $(OBJDIR)\neterr.obj   $(OBJDIR)\nettime.obj   \
       $(OBJDIR)\nsapaddr.obj $(OBJDIR)\oldstuff.obj  \
       $(OBJDIR)\packet32.obj $(OBJDIR)\pc_cbrk.obj   \
       $(OBJDIR)\pcarp.obj    $(OBJDIR)\pcbootp.obj   \
       $(OBJDIR)\pcbuf.obj    $(OBJDIR)\pcconfig.obj  \
       $(OBJDIR)\pcdbug.obj   $(OBJDIR)\pcdhcp.obj    \
       $(OBJDIR)\pcdns.obj    $(OBJDIR)\pcicmp.obj    \
       $(OBJDIR)\pcicmp6.obj  $(OBJDIR)\pcigmp.obj    \
       $(OBJDIR)\pcintr.obj   $(OBJDIR)\pcping.obj    \
       $(OBJDIR)\pcpkt.obj    $(OBJDIR)\pcpkt32.obj   \
       $(OBJDIR)\pcqueue.obj  $(OBJDIR)\pcrarp.obj    \
       $(OBJDIR)\pcrecv.obj   $(OBJDIR)\pcsed.obj     \
       $(OBJDIR)\pcstat.obj   $(OBJDIR)\pctcp.obj     \
       $(OBJDIR)\poll.obj     $(OBJDIR)\ports.obj     \
       $(OBJDIR)\powerpak.obj $(OBJDIR)\ppp.obj       \
       $(OBJDIR)\pppoe.obj    $(OBJDIR)\presaddr.obj  \
       $(OBJDIR)\printk.obj   $(OBJDIR)\profile.obj   \
       $(OBJDIR)\punycode.obj $(OBJDIR)\qmsg.obj      \
       $(OBJDIR)\receive.obj  $(OBJDIR)\res_comp.obj  \
       $(OBJDIR)\res_data.obj $(OBJDIR)\res_debu.obj  \
       $(OBJDIR)\res_init.obj $(OBJDIR)\res_loc.obj   \
       $(OBJDIR)\res_mkqu.obj $(OBJDIR)\res_quer.obj  \
       $(OBJDIR)\res_send.obj $(OBJDIR)\rs232.obj     \
       $(OBJDIR)\run.obj      $(OBJDIR)\select.obj    \
       $(OBJDIR)\settod.obj   $(OBJDIR)\shutdown.obj  \
       $(OBJDIR)\signal.obj   $(OBJDIR)\sock_dbu.obj  \
       $(OBJDIR)\sock_in.obj  $(OBJDIR)\sock_ini.obj  \
       $(OBJDIR)\sock_io.obj  $(OBJDIR)\sock_prn.obj  \
       $(OBJDIR)\sock_scn.obj $(OBJDIR)\sock_sel.obj  \
       $(OBJDIR)\socket.obj   $(OBJDIR)\sockopt.obj   \
       $(OBJDIR)\split.obj    $(OBJDIR)\stream.obj    \
       $(OBJDIR)\strings.obj  $(OBJDIR)\swsvpkt.obj   \
       $(OBJDIR)\syslog.obj   $(OBJDIR)\syslog2.obj   \
       $(OBJDIR)\tcp_fsm.obj  $(OBJDIR)\tcp_md5.obj   \
       $(OBJDIR)\tftp.obj     $(OBJDIR)\timer.obj     \
       $(OBJDIR)\transmit.obj $(OBJDIR)\udp_rev.obj   \
       $(OBJDIR)\version.obj  $(OBJDIR)\wdpmi.obj     \
       $(OBJDIR)\win_dll.obj  $(OBJDIR)\winadinf.obj  \
       $(OBJDIR)\winmisc.obj  $(OBJDIR)\winpkt.obj    \
       $(OBJDIR)\x32vm.obj    $(OBJDIR)\zadler32.obj  \
       $(OBJDIR)\zcompres.obj $(OBJDIR)\zcrc32.obj    \
       $(OBJDIR)\zdeflate.obj $(OBJDIR)\zgzio.obj     \
       $(OBJDIR)\zinfback.obj $(OBJDIR)\zinffast.obj  \
       $(OBJDIR)\zinflate.obj $(OBJDIR)\zinftree.obj  \
       $(OBJDIR)\ztrees.obj   $(OBJDIR)\zuncompr.obj  \
       $(OBJDIR)\zutil.obj

#
# This generated file is used for all 32-bit MSDOS targets
# (and when USE_FAST_PKT is defined). This enables a faster real-mode
# callback for the PKTDRVR receiver. Included as an array in pcpkt2.c.
#
PKT_STUB = pkt_stub.h

########################################################################

CC     = gcc
CFLAGS = -m32 -g -I../inc -Wc99-c11-compat \
         -DWATT32_BUILD -D__DJGPP__=2 -DWIN32 -D_WIN32 -DWATT32_DJGPP_MINGW \
         -D_INC_TYPES # -D__MINGW_H -D_INC__MINGW_H -D_MALLOC_H_ -W -Wall -Wno-strict-aliasing

#
# Now the tricky part:
#  -O0 -> '__NO_INLINE__' because of the 'gnu_inline' mess in gcc 5.x? Or '-std=c99'
#  Also force MingW's gcc to find *some* of djgpp's headers.
#
CFLAGS += -O0 -fgnu89-inline --include-directory-after $(DJDIR)/include

AS     = as
AFLAGS = --gdwarf2
OBJDIR = mingw-djgpp

OBJS := $(subst \,/,$(OBJS))
OBJS := $(subst .obj,.o,$(OBJS))

all: $(PKT_STUB) $(OBJDIR) $(OBJDIR)/cflags.h $(OBJS)
	@echo All done

$(OBJDIR):
	-mkdir $@

$(OBJDIR)/%.o: %.c
	$(CC) $(CFLAGS) -o $@ -c $<

$(OBJDIR)/%.o: %.S
	$(CC) -E $< > $(OBJDIR)/$*.iS
	$(AS) $(AFLAGS) $(OBJDIR)/$*.iS -o $@

$(OBJDIR)/chksum0.o:  chksum0.S
$(OBJDIR)/cpumodel.o: cpumodel.S

clean:
	rm -f $(OBJDIR)/*.o $(OBJDIR)/*.iS $(PKT_STUB) $(OBJDIR)/cflags.h
	@echo Cleaning done

#
# Assumes 'configur.bat djgpp' has been done:
#
-include ./djgpp/watt32.dep

lang.c: lang.l
	flex -8 -t lang.l > lang.c

$(OBJDIR)/cflags.h::
	@echo 'const char *w32_cflags = "$(CFLAGS)";' > $(OBJDIR)/cflags.h
	@echo 'const char *w32_cc     = "$(CC)";'    >> $(OBJDIR)/cflags.h

$(OBJDIR)/pcpkt.o: asmpkt.nas

$(PKT_STUB): asmpkt.nas
	../util/win32/nasm -f bin -l asmpkt.lst -o asmpkt.bin asmpkt.nas
	../util/win32/bin2c asmpkt.bin > $@

