/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define va_arg                  __builtin_va_arg
#define va_end                  __builtin_va_end
#define va_start(ap, last_arg)  __builtin_stdarg_start((ap), (last_arg))
typedef __builtin_va_list va_list;


void dputc (int ch);
void dputv (int x);
void dputs (const char *s);
void dprintf (const char *fmt, ...);


void
dputc (int ch)
{
    if (ch == '\n') {
	__asm("movb $0x02, %%ah; int $0x21"::"d"('\r'):"%eax");
    }
    __asm("movb $0x02, %%ah; int $0x21"::"d"(ch):"%eax");
}


void
dputs (const char *s)
{
    while (*s != 0) {
        dputc(*s++);
    }
}


void
dputv (int x)
{
    char hexbuf[9];
    int c, i = 9;
    hexbuf[--i] = 0;
    while (i) {
        c = x & 0xf;
        if (c > 9) {
            c += 7;
        }
        c += 0x30;
        hexbuf[--i] = c;
        x >>= 4;
    }
    dputs(hexbuf);
}


void
dprintf (const char *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    while (!0) {
        int ch = *fmt++;
        if (ch == '%') {
            ch = *fmt++;
            if (ch == 'x') {
                int v = va_arg(ap, int);
                dputv(v);
                continue;
            } else if (ch == 's') {
                char *s = va_arg(ap, char *);
                dputs(s);
                continue;
            } else if (ch != '%') {
                dputc('%');
            }
        }
        if (!ch) {
            break;
        }
        dputc(ch);
    }
    va_end(ap);
}
